/*
 * common.h
 *
 *  Created on: Sep 2, 2013
 *      Author: vdu1kor
 */

#ifndef COMMON_H_
#define COMMON_H_

#include "IAmControl.h"
#include "IAmControl.h"

#define vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(poClass) \
    if (poClass == NULL) {\
      FATAL_M_ASSERT_ALWAYS();\
      return; \
  }

#define iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(poClass,retValue) \
    if (poClass == NULL) {\
      FATAL_M_ASSERT_ALWAYS();\
      return retValue; \
  }
#define SET_STATUS(flag,bit) (flag |= bit)
#define UNSET_STATUS(flag,bit) (flag &= ~bit)

#define IS_SET(flag,bit) (((flag & bit) == bit)?true:false)
#define IS_GAM_READY(flag) (((flag & \
                (STATUS_AM_COMMAND_READY |STATUS_FC_AM_SRV_AVLB|STATUS_FC_ARM_SRV_AVLB)) == \
                (STATUS_AM_COMMAND_READY |STATUS_FC_AM_SRV_AVLB|STATUS_FC_ARM_SRV_AVLB)) \
                 ?true:false)



/*
 * Enumaration to define states of command,routing plugin, fc_audioMgr and fc_audiorouteMgr
 * STATUS_AM_COMMAND_READY/STATUS_AM_ROUTING_READY :  1 = if status confirmCommandReady/confirmRoutingReady received
 *                                   0 = if status confirmCommandRundown/confirmRoutingRundown received
 *                                   OR confirmCommandReady/confirmRoutingReady not received
 * STATUS_FC_AM_SRV_AVLB/STATUS_FC_ARM_SRV_AVLB : 1 = if service available
 *                         : 0 = if service unavailable
 */
typedef enum {
  STATUS_AM_COMMAND_READY = 1,  // 2^0, bit 0
  STATUS_FC_AM_SRV_AVLB   = 2,  // 2^1, bit 1  /*STATUS_AM_ROUTING_READY = 2,*/
  STATUS_FC_ARM_SRV_AVLB  = 4    // 2^2, bit 2

}tenConfirmationStatus;

using namespace am;

struct rMainConnectionSet
{
   am_Handle_s handle;
   am_sourceID_t sourceID; //VVD
   am_mainConnectionID_t connectionID;

   //VVD
   //std::vector<rHandleStatus> listHandleStaus;
};

typedef enum UserRequest
{
   REQUEST_UNKNOWN = 0,
   REQUEST_SOURCE_ROUTE_ACTIVITY = 1,
   REQUEST_VOLUME = 2,
   REQUEST_MUTE_DEMUTE = 3,
   REQUEST_MSP_BASS = 4,
   REQUEST_MSP_TREBLE = 5,
   REQUEST_MSP_MIDRANGE = 6,
   REQUEST_MSP_LOUDNESS = 7,
   REQUEST_MSP_BALANCE = 8,
   REQUEST_MSP_FADER = 9,
   REQUEST_MSP_DYNA_COMPRESSION = 10,
   REQUEST_MSP_EQU_PRESET = 11,
   REQUEST_MSP_SDVC = 12,
   REQUEST_MSP_SND_OPTIMIZATION = 13,
   REQUEST_MSP_AUX = 14,
   REQUEST_MSP_BEEP_LEVEL = 15,
   REQUEST_SYP_BEEP = 16,
   REQUEST_SYP_FADER_STATUS_ACTIVE = 17,
   REQUEST_SYP_VOL_MODE = 18,
   REQUEST_MSP_SETTING_SURROUND = 19,
   REQUEST_MSP_PDCACTIVE = 20,
   REQUEST_MSP_PDCATTENUATIONLEVEL = 21,
   REQUEST_MSP_VOLUME_ENTERTAINMENT = 22,
   REQUEST_MSP_VOLUME_PHONE = 23,
   REQUEST_MSP_VOLUME_ONVOL = 24,
   REQUEST_MSP_VOLUME_TA = 25,
   REQUEST_MSP_VOLUME_BEEP = 26,
   REQUEST_MSP_BTAUDIO_IN = 27,
   REQUEST_MSP_GALA_GAIN = 28,
   REQUEST_MSP_VOLUME_LOCK = 29,
   REQUEST_SET_CONTROLLER_READY = 30,
   REQUEST_SET_CONTROLLER_RUNDOWN = 31
   //REQUEST_LIFE_CYCLE_SHUTDOWNTYPE_NORMAL = 32,
   //REQUEST_LIFE_CYCLE_SHUTDOWNTYPE_RUNUP = 33

}tenUserRequest;

typedef struct rSourceRouteActivity
{
   tenUserRequest enCCAResponseType;
      uint8_t Source;
      uint8_t PossibleNextSource;
      uint8_t Resource;
      uint8_t Activity;
}trSourceRouteActivity;

typedef struct rVolumeStatus
{
      uint8_t VolumeMode;
      uint8_t Resource;
      uint8_t Channel;
      uint8_t Volume;
      uint8_t Source;
}trVolumeStatus;



typedef union INC_CCA_Response
{
   //tenCCAResponse enCCAResponseType;
   trSourceRouteActivity rSrcRouteActivity;
   //trVolumeStatus rVolumeStatus;

}tuCCARepsonse;

struct rMainSinkSoundPropertySet
{
    am_sinkID_t sinkID;
    am_Handle_s handle;
    am_MainSoundProperty_s mainSoundProperty;
};

#endif /* COMMON_H_ */
